#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int calculateHappiness(const vector<int>& row1, const vector<int>& row2, int n) {
    int happiness = 0;
    int currentParity = row1[0] % 2; // Parnost prvog polja

    for (int j = 1; j < n; ++j) {
        if (j % 2 == 1) { // Ako smo na donjem redu
            if (row2[j] % 2 == currentParity) happiness++;
            currentParity = row2[j] % 2;
        } else { // Ako smo na gornjem redu
            if (row1[j] % 2 == currentParity) happiness++;
            currentParity = row1[j] % 2;
        }
    }
    return happiness;
}

int solveTestCase(int n, vector<int>& row1, vector<int>& row2) {
    int maxHappiness = 0;

    // Probamo sve kombinacije zamene kolona
    for (int i = 0; i < n; ++i) {
        swap(row1[i], row2[i]);
        maxHappiness = max(maxHappiness, calculateHappiness(row1, row2, n));
        swap(row1[i], row2[i]); // Vratimo nazad
    }

    return maxHappiness;
}

int main() {
    int t;
    cin >> t;

    while (t--) {
        int n;
        cin >> n;

        vector<int> row1(n), row2(n);
        for (int i = 0; i < n; ++i) cin >> row1[i];
        for (int i = 0; i < n; ++i) cin >> row2[i];

        cout << solveTestCase(n, row1, row2) << endl;
    }

    return 0;
}